function table=latexTable42(SMs,words)

%
% Generate Table 4-2 in LaTex format
%
% Dongrui WU (dongruiw@usc.edu), 7/9/2008

N=length(words);
M=5*20+25 +6;
row=1;

for i=1:N
    if i<10
        table(row,1:23)=[num2str(i) '.  ' words(i,:)];
    else
        table(row,1:23)=[num2str(i) '. ' words(i,:)];
    end

    [temp,index]=sort(SMs(i,:),'descend');
    for k=1:5
        p(k)=0;
        for j=1:N
            if temp(j)>=1-0.1*k & temp(j)<1.1-0.1*k
                table(row+p(k),(24+20*(k-1)):(43+20*(k-1)))=['&' words(index(j),:)];
                p(k)=p(k)+1;
            end
        end
    end
    row=row+max(p);
    table(row-1,M-5:M)='\hline';
end

for i=1:row-1
    for j=24:M-8
        if ~mod(j-24,20)
            table(i,j)='&';
        end
    end
    table(i,M-7:M-6)='\\';
end
